/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.impl;

import com.cisco.pt.EncodedBuffer;
import com.cisco.pt.IPAddress;
import com.cisco.pt.IPV6Address;
import com.cisco.pt.MACAddress;
import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCParameter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPCCall {
    protected String name;
    protected List<IPCParameter> parameters = new ArrayList<IPCParameter>();
    public static final IPCParameter LAST_PARAMETER = new IPCParameter.VoidParameter();

    public IPCCall(String name) {
        this.name = name;
    }

    public void encode(EncodedBuffer buff) {
        buff.putString(this.name);
        for (IPCParameter parameter : this.parameters) {
            parameter.encode(buff);
        }
        LAST_PARAMETER.encode(buff);
    }

    public void addBoolParameter(boolean value) {
        this.parameters.add(new IPCParameter.BoolParameter(value));
    }

    public void addByteParameter(byte value) {
        this.parameters.add(new IPCParameter.ByteParameter(value));
    }

    public void addByteListParameter(List<Byte> value) {
        this.parameters.add(new IPCParameter.ByteListParameter(value));
    }

    public void addDoubleParameter(double value) {
        this.parameters.add(new IPCParameter.DoubleParameter(value));
    }

    public void addIntParameter(int value) {
        this.parameters.add(new IPCParameter.IntParameter(value));
    }

    public void addIPAddressParameter(IPAddress value) {
        this.parameters.add(new IPCParameter.IPAddressParameter(value));
    }

    public void addIPV6AddressParameter(IPV6Address value) {
        this.parameters.add(new IPCParameter.IPV6AddressParameter(value));
    }

    public void addLongParameter(long value) {
        this.parameters.add(new IPCParameter.LongParameter(value));
    }

    public void addMACAddressParameter(MACAddress value) {
        this.parameters.add(new IPCParameter.MACAddressParameter(value));
    }

    public void addQStringParameter(String value) {
        this.parameters.add(new IPCParameter.QStringParameter(value));
    }

    public void addShortParameter(short value) {
        this.parameters.add(new IPCParameter.ShortParameter(value));
    }

    public void addShortParameter(Short value) {
        this.parameters.add(new IPCParameter.ShortParameter(value));
    }

    public void addStringParameter(String value) {
        this.parameters.add(new IPCParameter.StringParameter(value));
    }

    public void addUUIDParameter(UUID value) {
        this.parameters.add(new IPCParameter.UUIDParameter(value));
    }
}

